/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: BusStateDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 4.04.07 19:18 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Bus State Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        04.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file BusStateDlg.h
///   Bus State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Bus State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CBusStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CBusStateDlg)

public:
	CBusStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CBusStateDlg();

// Dialog Data
	enum { IDD = IDD_BUSSTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t        m_ulSetTimeout;   //!< Timeout when calling Set Bus State
  CComboBox       m_cNewStateCtrl;  //!< Set Bus State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
